/*********************************************************************
 * FileName:        user.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         Microchip Technology, Inc.
 *
 * modified by sprut
 *
 ********************************************************************/

/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <usart.h>
#include "system\typedefs.h"
#include "system\usb\usb.h"
#include "io_cfg.h"             // I/O pin mapping
#include "user\user.h"


/** Configuration ********************************************************/
#pragma config PLLDIV = 5, CPUDIV = OSC1_PLL2, USBDIV = 2, FOSC = HSPLL_HS
#pragma config PWRT = ON
#pragma config BOR = OFF
#pragma config VREGEN = ON //USB Voltage Regulator Enable:
#pragma config WDT = OFF //Watchdog Timer:
#pragma config MCLRE = ON //MCLR Enable:
#pragma config PBADEN = OFF //PORTB<4:0> pins are configured as digital I/O on Reset
#pragma config LVP = OFF //Low Voltage ICSP:


/** V A R I A B L E S ********************************************************/
#pragma udata
byte counter;
byte trf_state;

DATA_PACKET dataPacket;


/** P R I V A T E  P R O T O T Y P E S ***************************************/
void ReadPOT(void);
void ServiceRequests(void);


/** D E C L A R A T I O N S **************************************************/
#pragma code
void UserInit(void)
{
    mInitAllLEDs();
    mInitPOT();
    ADCON2bits.ADFM = 1;   // ADC result right justified
}//end UserInit


/******************************************************************************
 * Function:        void ProcessIO(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This function is a place holder for other user routines.
 *                  It is a mixture of both USB and non-USB tasks.
 *
 * Note:            None
 *****************************************************************************/
void ProcessIO(void)
{   
    // User Application USB tasks
    if((usb_device_state < CONFIGURED_STATE)||(UCONbits.SUSPND==1)) return;    
    ServiceRequests();
}//end ProcessIO


// Potentiometer an AN0 auslesen *************************
void ReadPOT(void)
{
    ADCON0bits.GO = 1;              // Start AD conversion
    while(ADCON0bits.NOT_DONE);     // Wait for conversion
    return;
}//end ReadPOT


// Kommando auswerten und ausfhren **********************
void ServiceRequests(void)
{
    byte index;
    
    // wurde via USB etwas empfangen?
    if(USBGenRead((byte*)&dataPacket,sizeof(dataPacket)))
    {
        counter = 0;
        switch(dataPacket.CMD)
        {
			// eine Kennummer (0x0200) aus dem PIC auslesen
            case READ_VERSION:
                //dataPacket._byte[1] is len
                dataPacket._byte[2] = MINOR_VERSION;
                dataPacket._byte[3] = MAJOR_VERSION;
                counter=0x04;
                break;
		    //LEDs ein und aus schalten
            case LED_ONOFF:
                counter = 0x01;
                if(dataPacket.ID == 0)
                {
                    mLED_1_On();
                }
                else if(dataPacket.ID == 1)
                {
                    mLED_2_On();
                }
                else if(dataPacket.ID == 2)
                {
                    mLED_3_On();
                }
                else if(dataPacket.ID == 3)
                {
                    mLED_4_On();
                }
                else if(dataPacket.ID == 4)
                {
                    mLED_1_Off();
                }
                else if(dataPacket.ID == 5)
                {
                    mLED_2_Off();
                }
                else if(dataPacket.ID == 6)
                {
                    mLED_3_Off();
                }
                else if(dataPacket.ID == 7)
                {
                    mLED_4_Off();
                }
                else
                    counter = 0x00;
                break;
            //Potistellung auslesen   
            case RD_POT:
                ReadPOT();
                dataPacket._byte[1] = ADRESL;
                dataPacket._byte[2] = ADRESH;
                counter=0x03;
                break;
                
            case RESET:
                Reset();
                break;
                
            default:
                break;
        }//end switch()
        if(counter != 0)
        {
            if(!mUSBGenTxIsBusy())
                USBGenWrite((byte*)&dataPacket,counter);
        }//end if
    }//end if

}//end ServiceRequests


/** EOF user.c ***************************************************************/
