/*********************************************************************
 * FileName:        io_cfg.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         Microchip Technology, Inc.
 *
 *
 * Angepasst von sprut
 *
 * Makros fr die Festlegung der Hardware
 * ausgelegt fr 28-polige Testplatine
 *
 ********************************************************************/


#ifndef IO_CFG_H
#define IO_CFG_H


/** I N C L U D E S *************************************************/
#include "autofiles\usbcfg.h"


/** T R I S *********************************************************/
#define INPUT_PIN           1
#define OUTPUT_PIN          0


/** U S B ***********************************************************/
#define tris_usb_bus_sense  TRISAbits.TRISA1    // Input

#if defined(USE_USB_BUS_SENSE_IO)
#define usb_bus_sense       PORTAbits.RA1
#else
#define usb_bus_sense       1
#endif

#define tris_self_power     TRISAbits.TRISA2    // Input

#if defined(USE_SELF_POWER_SENSE_IO)
#define self_power          PORTAbits.RA2
#else
#define self_power          1
#endif


/** L E D ***********************************************************/
// LEDs hngen an RB0..RB3

#define mInitAllLEDs()      LATB &= 0xF0; TRISB &= 0xF0;

#define mLED_1              LATBbits.LATB0
#define mLED_2              LATBbits.LATB1
#define mLED_3              LATBbits.LATB2
#define mLED_4              LATBbits.LATB3

#define mLED_1_On()         mLED_1 = 1;
#define mLED_2_On()         mLED_2 = 1;
#define mLED_3_On()         mLED_3 = 1;
#define mLED_4_On()         mLED_4 = 1;

#define mLED_1_Off()        mLED_1 = 0;
#define mLED_2_Off()        mLED_2 = 0;
#define mLED_3_Off()        mLED_3 = 0;
#define mLED_4_Off()        mLED_4 = 0;

#define mLED_1_Toggle()     mLED_1 = !mLED_1;
#define mLED_2_Toggle()     mLED_2 = !mLED_2;
#define mLED_3_Toggle()     mLED_3 = !mLED_3;
#define mLED_4_Toggle()     mLED_4 = !mLED_4;


/** S W I T C H *****************************************************/
//Taster hngen an RB4..RB7

#define mInitAllSwitches()  TRISBbits.TRISB4=1;TRISBbits.TRISB5=1;TRISBbits.TRISB6=1;TRISBbits.TRISB7=1;
#define mInitSwitch1()      TRISBbits.TRISB4=1;
#define mInitSwitch2()      TRISBbits.TRISB5=1;
#define mInitSwitch3()      TRISBbits.TRISB6=1;
#define mInitSwitch4()      TRISBbits.TRISB7=1;
#define sw1                 PORTBbits.RB4
#define sw2                 PORTBbits.RB5
#define sw3                 PORTBbits.RB4
#define sw4                 PORTBbits.RB5

/** P O T ***********************************************************/
//ein Poti hngt an RA0=AN0

#define mInitPOT()          TRISAbits.TRISA0=1;ADCON0=0x01;ADCON2=0x3C;


#endif //IO_CFG_H
