/** I N C L U D E S **********************************************************/ 
 #include <p18cxxx.h> 
 #include "delays.h"                        // fr die Warteschleife 
   

// 8 MHz Takt
/** Configuration ********************************************************/
#pragma config PLLDIV = 2, CPUDIV = OSC1_PLL2, USBDIV = 2, FOSC = HSPLL_HS //CPU=48 MHz
#pragma config PWRT   = ON
#pragma config BOR    = OFF
#pragma config VREGEN = ON 		//USB Voltage Regulator Enable:
#pragma config WDT    = OFF 	//Watchdog Timer:
#pragma config MCLRE  = ON 		//MCLR Enable:
#pragma config PBADEN = OFF 	//PORTB<4:0> pins are configured as digital I/O on Reset
#pragma config LVP    = OFF 	//Low Voltage ICSP:



/** V E C T O R  R E M A P P I N G *******************************************/

extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code _RESET_INTERRUPT_VECTOR = 0x000800
void _reset (void)
{
    _asm goto _startup _endasm
}
#pragma code

#pragma code _HIGH_INTERRUPT_VECTOR = 0x000808
void _high_ISR (void)
{
    ;
}

#pragma code _LOW_INTERRUPT_VECTOR = 0x000818
void _low_ISR (void)
{
    ;
}
#pragma code

 /** D E C L A R A T I O N S **************************************************/ 
//48 MHz /4 /10000 /250 /4 /2 = 0,6Hz
 #pragma code 
 void main(void) 
 { 
   LATB  = 0x00;  
   TRISB = 0x7E; 		// RB0 & RB7

   while(1) 
   { 
     LATB = 0x80;
     Delay10KTCYx(250); 
     Delay10KTCYx(250); 
     Delay10KTCYx(250); 
     Delay10KTCYx(250); 
     LATB = 0x01; 
     Delay10KTCYx(250); 
     Delay10KTCYx(250); 
     Delay10KTCYx(250); 
     Delay10KTCYx(250); 
   }//end while 
 }//end main 
  
