;******************************************************************************
; sprut (zero) Bredendiek 02/2006 
;
; Wechselblinklicht am Port D,  RD0 & RD1
;
; Taktquelle: 31 kHz intern
;
;******************************************************************************
;
; Pinbelegung
;	----------------------------------	
;	PORTD:	0 LED 1	   
;		1 LED 2	    
;
;******************************************************************************

	LIST P=18F66J60			;der Typ des Prozessors
	#include <P18F66j60.INC>	;processor-spezifische Variablendefinitionen

;******************************************************************************
;Configuration bits
    CONFIG	FOSC2  = OFF	; intrc 31 kHz
    CONFIG	WDT    = OFF	; watchdog off
    CONFIG	DEBUG  = OFF
    CONFIG	XINST  = OFF
    CONFIG	CP0    = OFF
    CONFIG	ETHLED = OFF


;******************************************************************************
;Variable definitions

	CBLOCK	0x000
	loops		
	ENDC

;******************************************************************************
;Reset vector
; hier beginnt der Prozessor beim Reset

	ORG	0x0000
	goto	Main		;go to start of main code

;******************************************************************************
;Start of main program

Main:
; Port D kmnfigurieren
; alle Pins sind output
	clrf	TRISD
	clrf	PORTD		; alle LEDs ausschalten

; 1. LED einschalten 
	bsf	PORTD,0		; LED an RD0 einschalten

; Lauflicht
Loop
	call	Wait		; Wartezeit
	rlncf	PORTD,f		; laufen zur 2.LED
	call	Wait		; Wartezeit
	rrncf	PORTD,f		; laufen zur 1.LED
	goto	Loop	

;******************************************************************************
; Warteschleife 250 ms
; 31 kHZ Takt
; 8 Zyklen pro loop = 1ms

Wait
	movlw	D'250'		; 250 ms Pause
	movwf	loops	

Wai			        ; Zeitkonstante fr 1ms (8 Takte)
	nop
	nop
	nop	
	nop              
        decfsz  loops, F       ; 250 ms vorbei?
        goto    Wai            ; nein, noch nicht
        retlw   0              ; das Warten hat ein Ende

;******************************************************************************
;End of program

	END
